<?php
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/*********************
*** KNOWLEDGE BASE ***
**********************/
add_action( 'init', 'manual_kb_post_type', 0 );
if ( ! function_exists('manual_kb_post_type') ) {

// Register Custom Post Type
function manual_kb_post_type() {
	global $theme_options;
	
	if( isset($theme_options['kb-slug-name']) && $theme_options['kb-slug-name'] != ''  ) {
		$new_slug_name = $theme_options['kb-slug-name'];
	} else {
		$new_slug_name = 'knowledgebase';
	}
	
	if( isset($theme_options['kb-comment-status']) && $theme_options['kb-comment-status'] == true ) {
		$activate_comment = 'comments';
	} else {
		$activate_comment = '';
	}
	
	if( isset($theme_options['kb-breadcrumb-name']) && $theme_options['kb-breadcrumb-name'] != ''  ) {
		$kb_breadcrumb_name = $theme_options['kb-breadcrumb-name'];
	} else {
		$kb_breadcrumb_name = 'Knowledge Base';
	}
	
	if( isset($theme_options['kb-gutenberg-editor-onoff']) && $theme_options['kb-gutenberg-editor-onoff'] == true ) {
		$kb_gutenberg_editor = true;
	} else {
		$kb_gutenberg_editor = false;
	}
	
	if( isset($theme_options['kb-post-type-has-archive']) && $theme_options['kb-post-type-has-archive'] == true ) {
		$has_archive = true;
	} else {
		$has_archive = false;
	}
	
	if( isset($theme_options['kb-post-type-support-custom-fields']) && $theme_options['kb-post-type-support-custom-fields'] == true ) {
		$custom_fields = 'custom-fields';
	} else {
		$custom_fields = '';
	}
	
	// Get Knowledge slug from options
	$labels = array(
		'name'                => esc_html__( 'Knowledge Base', 'manual-framework' ),
		'singular_name'       => sprintf( esc_html( _x('%s', 'Knowledge Base', 'manual-framework') ), $kb_breadcrumb_name),
		'menu_name'           => esc_html__( 'Knowledge Base', 'manual-framework' ),
		'parent_item_colon'   => esc_html__( 'Parent Knowledge Base:', 'manual-framework' ),
		'all_items'           => esc_html__( 'All Knowledge Base', 'manual-framework' ),
		'view_item'           => esc_html__( 'View Knowledge Base', 'manual-framework' ),
		'add_new_item'        => esc_html__( 'Add New Knowledge Base', 'manual-framework' ),
		'add_new'             => esc_html__( 'New Knowledge Base', 'manual-framework' ),
		'edit_item'           => esc_html__( 'Edit Knowledge Base', 'manual-framework' ),
		'update_item'         => esc_html__( 'Update Knowledge Base', 'manual-framework' ),
		'search_items'        => esc_html__( 'Search Knowledge Base', 'manual-framework' ),
		'not_found'           => esc_html__( 'No Knowledge Base found', 'manual-framework' ),
		'not_found_in_trash'  => esc_html__( 'No Knowledge Base found in Trash', 'manual-framework' ),
	);

	$rewrite = array(
		'slug'                => $new_slug_name,
		'with_front'          => false,
		'pages'               => true,
		'feeds'               => true,
	);

	$args = array(
		'label'               => esc_html__( 'manual_kb', 'manual-framework' ),
		'description'         => esc_html__( 'Knowledge Base Post Type', 'manual-framework' ),
		'labels'              => $labels,
		'supports'            => array( 'title', 'author', 'revisions', 'editor', 'page-attributes', 'post-formats', 'thumbnail', $activate_comment , $custom_fields ),
		'taxonomies'          => array( 'manualknowledgebasecat' ),
		'hierarchical'        => true,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'menu_position'       => 5,
		'can_export'          => true,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'rewrite'             => $rewrite,
		'capability_type'     => 'post',
		'menu_icon'           => plugin_dir_url( __FILE__ ) . 'img/kb.png',
		'show_in_rest'        => $kb_gutenberg_editor,
		'has_archive'         => $has_archive,
	);

	register_post_type( 'manual_kb', $args );
	register_taxonomy_for_object_type( 'post_format', 'manual_kb' );
	
}

}


// Register KB Category Custom Taxonomy
if ( ! function_exists('manual_kb_category_taxonomy') ) {

function manual_kb_category_taxonomy()  {
	
	global $theme_options;
	
	if( isset($theme_options['kb-cat-slug-name']) && $theme_options['kb-cat-slug-name'] != ''  ) {
		$new_cat_slug_name = $theme_options['kb-cat-slug-name'];
	} else {
		$new_cat_slug_name = 'kb';
	}
	
	if( isset($theme_options['kb-gutenberg-editor-onoff']) && $theme_options['kb-gutenberg-editor-onoff'] == true ) {
		$kb_gutenberg_editor = true;
	} else {
		$kb_gutenberg_editor = false;
	}
	
	$labels = array(
		'name'                       => esc_html__( 'Knowledge Base Categories', 'manual-framework' ),
		'singular_name'              => esc_html__( 'Knowledge Base Category', 'manual-framework' ),
		'menu_name'                  => esc_html__( 'Knowledge Base Categories', 'manual-framework' ),
		'all_items'                  => esc_html__( 'All Categories', 'manual-framework' ),
		'parent_item'                => esc_html__( 'Parent Category', 'manual-framework' ),
		'parent_item_colon'          => esc_html__( 'Parent Category:', 'manual-framework' ),
		'new_item_name'              => esc_html__( 'New Category Name', 'manual-framework' ),
		'add_new_item'               => esc_html__( 'Add New Category', 'manual-framework' ),
		'edit_item'                  => esc_html__( 'Edit Category', 'manual-framework' ),
		'update_item'                => esc_html__( 'Update Category', 'manual-framework' ),
		'separate_items_with_commas' => esc_html__( 'Separate categories with commas', 'manual-framework' ),
		'search_items'               => esc_html__( 'Search categories', 'manual-framework' ),
		'add_or_remove_items'        => esc_html__( 'Add or remove categories', 'manual-framework' ),
		'choose_from_most_used'      => esc_html__( 'Choose from the most used categories', 'manual-framework' ),
	);

	$rewrite = array(
		'slug'                       => $new_cat_slug_name,
		'with_front'                 => false,
		'hierarchical'               => true,
	);

	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => false,
		'query_var'                  => true,
		'rewrite'                    => $rewrite,
		'show_in_rest'               => $kb_gutenberg_editor,
	);

	register_taxonomy( 'manualknowledgebasecat', 'manual_kb', $args );
	flush_rewrite_rules();
}

// Hook into the 'init' action
add_action( 'init', 'manual_kb_category_taxonomy', 0 );

}



// Register KB Tag Custom Taxonomy
if ( ! function_exists('manual_kb_tag_taxonomy') ) {

function manual_kb_tag_taxonomy()  {
	
	global $theme_options;
	
	if( isset($theme_options['kb-tag-slug-name']) && $theme_options['kb-tag-slug-name'] != ''  ) {
		$kb_tag_slug_name = $theme_options['kb-tag-slug-name'];
	} else {
		$kb_tag_slug_name = 'kb-tag';
	}
	
	if( isset($theme_options['kb-gutenberg-editor-onoff']) && $theme_options['kb-gutenberg-editor-onoff'] == true ) {
		$kb_gutenberg_editor = true;
	} else {
		$kb_gutenberg_editor = false;
	}
	
	$labels = array(
		'name'                       => esc_html__( 'Knowledge Base Tags', 'manual-framework' ),
		'singular_name'              => esc_html__( 'Knowledge Base Tag', 'manual-framework' ),
		'menu_name'                  => esc_html__( 'Knowledge Base Tags', 'manual-framework' ),
		'all_items'                  => esc_html__( 'All Tags', 'manual-framework' ),
		'parent_item'                => esc_html__( 'Parent Tag', 'manual-framework' ),
		'parent_item_colon'          => esc_html__( 'Parent Tag:', 'manual-framework' ),
		'new_item_name'              => esc_html__( 'New Tag Name', 'manual-framework' ),
		'add_new_item'               => esc_html__( 'Add New Tag', 'manual-framework' ),
		'edit_item'                  => esc_html__( 'Edit Tag', 'manual-framework' ),
		'update_item'                => esc_html__( 'Update Tag', 'manual-framework' ),
		'separate_items_with_commas' => esc_html__( 'Separate tags with commas', 'manual-framework' ),
		'search_items'               => esc_html__( 'Search tags', 'manual-framework' ),
		'add_or_remove_items'        => esc_html__( 'Add or remove tags', 'manual-framework' ),
		'choose_from_most_used'      => esc_html__( 'Choose from the most used tags', 'manual-framework' ),
	);

	$rewrite = array(
		'slug'                       => $kb_tag_slug_name,
		'with_front'                 => false,
		'hierarchical'               => false,
	);

	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => false,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'query_var'                  => true,
		'rewrite'                    => $rewrite,
		'show_in_rest'               => $kb_gutenberg_editor,
	);
	register_taxonomy( 'manual_kb_tag', 'manual_kb', $args );
	flush_rewrite_rules();
}

// Hook into the 'init' action
add_action( 'init', 'manual_kb_tag_taxonomy', 0 );

}
?>