<?php 
/**
 * @author     Manual
 * @copyright  (c) Copyright by Manual
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      4.0
 */

/******************************************
 *************  BUTTON ********************
******************************************/
class manual__button_header_widget_call extends WP_Widget {

	function __construct() {
		parent::__construct(
			'widget_manual_header_button',
			esc_html__( 'Manual - Button', 'manual-framework' ),
			array( 'description' => esc_html__( 'Display button on the theme header or on any other section', 'manual-framework' ), )
		);
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_footer-widgets.php', array( $this, 'print_scripts' ), 9999 );
	}
	
	public function enqueue_scripts( $hook_suffix ) {
		if ( 'widgets.php' !== $hook_suffix ) {
			return;
		}
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'wp-color-picker' );
		wp_enqueue_script( 'underscore' );
	}
	
	public function print_scripts() {
		?>
		<script>
			( function( $ ){
				function initColorPicker( widget ) {
					widget.find( '.color-picker' ).wpColorPicker( {
						change: _.throttle( function() { // For Customizer
							$(this).trigger( 'change' );
						}, 3000 )
					});
				}

				function onFormUpdate( event, widget ) {
					initColorPicker( widget );
				}

				$( document ).on( 'widget-added widget-updated', onFormUpdate );

				$( document ).ready( function() {
					$( '#widgets-right .widget:has(.color-picker)' ).each( function () {
						initColorPicker( $( this ) );
					} );
				} );
			}( jQuery ) );
		</script>
		<?php
	}

	public function widget( $args, $instance ) {

		$defaults = manual__widget_botton_defaults();
		$unique_id = esc_attr( $args['widget_id'] );
		echo wp_kses_post($args['before_widget']);
		$new_window = ( isset( $instance['new_window'] ) && '' !== $instance['new_window'] ) ? 'target="_blank"' : $defaults['new_window'];
		$font_size = ( isset( $instance['font_size'] ) && '' !== $instance['font_size'] ) ? $instance['font_size'] : $defaults['font_size'];
		$botton_padding = ( isset( $instance['botton_padding'] ) && '' !== $instance['botton_padding'] ) ? $instance['botton_padding'] : $defaults['botton_padding'];
		$botton_margin = ( isset( $instance['botton_margin'] ) && '' !== $instance['botton_margin'] ) ? $instance['botton_margin'] : $defaults['botton_margin'];
		$botton_text = ( isset( $instance['botton_text'] ) && '' !== $instance['botton_text'] ) ? $instance['botton_text'] : $defaults['botton_text'];
		$botton_text_color = ( isset( $instance['botton_text_color'] ) && '' !== $instance['botton_text_color'] ) ? $instance['botton_text_color'] : $defaults['botton_text_color'];
		$botton_background_color = ( isset( $instance['botton_background_color'] ) && '' !== $instance['botton_background_color'] ) ? $instance['botton_background_color'] : $defaults['botton_background_color'];
		$botton_background_hover_color = ( isset( $instance['botton_background_hover_color'] ) && '' !== $instance['botton_background_hover_color'] ) ? $instance['botton_background_hover_color'] : $defaults['botton_background_hover_color'];
		$link_url = ( isset( $instance['link_url'] ) && '' !== $instance['link_url'] ) ? $instance['link_url'] : $defaults['link_url'];
		
		$text_color_css = $botton_background_color_css = '';
		if( isset($botton_text_color) && $botton_text_color != '' ) $text_color_css = 'color:'.esc_attr($botton_text_color).';';
		
		//Control Flip
		if( isset( $instance['flip_text_link'] ) && '' !== $instance['flip_text_link'] && is_user_logged_in() ) {
			$botton_text = ( isset( $instance['flip_botton_text'] ) && '' !== $instance['flip_botton_text'] ) ? $instance['flip_botton_text'] : $defaults['flip_botton_text'];
			$link_url = ( isset( $instance['flip_link_url'] ) && '' !== $instance['flip_link_url'] ) ? $instance['flip_link_url'] : $defaults['flip_link_url'];
			$new_window = ( isset( $instance['flip_new_window'] ) && '' !== $instance['flip_new_window'] ) ? 'target="_blank"' : $defaults['flip_new_window'];
		}
		
		echo $output = '';
		$time_start = microtime(true);
		$time_start = explode(".", $time_start);
		if( isset($botton_background_color) && $botton_background_color != '' ) {
			echo '<style>.mt__widget_btm_hover_'.$time_start[1].' { background-color:'.esc_attr($botton_background_color).'!important; }</style>';
		}
		if( isset($botton_background_hover_color) && $botton_background_hover_color != '' ) {
			echo '<style>.mt__widget_btm_hover_'.$time_start[1].':hover { background-color:'.esc_attr($botton_background_hover_color).'!important; }</style>';
		}
		
		echo $output .= '<div><a  href="'.esc_url($link_url).'" '.$new_window.' style="min-height:auto; margin:'.esc_attr($botton_margin).';padding:'.esc_attr($botton_padding).';" class="custom-botton mt__widget_btm_hover_'.$time_start[1].'"> 
							  <span class="button-text" style="font-size:'.esc_attr($font_size).'px; '.esc_attr($text_color_css).'"> '.esc_html__($botton_text).' </span> 
						</a></div>';

		echo wp_kses_post($args['after_widget']);
	}

	public function form( $instance ) {
		
		$defaults = manual__widget_botton_defaults();
		$botton_margin = ( isset( $instance[ 'botton_margin' ] ) && '' !== $instance[ 'botton_margin' ] ) ? $instance[ 'botton_margin' ] : $defaults['botton_margin'];
		$botton_padding = ( isset( $instance[ 'botton_padding' ] ) && '' !== $instance[ 'botton_padding' ] ) ? $instance[ 'botton_padding' ] : $defaults['botton_padding'];
		$font_size = ( isset( $instance[ 'font_size' ] ) && '' !== $instance[ 'font_size' ] ) ? $instance[ 'font_size' ] : $defaults['font_size'];
		$new_window = ( isset( $instance[ 'new_window' ] ) && '' !== $instance[ 'new_window' ] ) ? $instance[ 'new_window' ] : $defaults['new_window'];
		$botton_text = ( isset( $instance['botton_text'] ) && '' !== $instance['botton_text'] ) ? $instance['botton_text'] : $defaults['botton_text'];
		$botton_text_color = ( isset( $instance['botton_text_color'] ) && '' !== $instance['botton_text_color'] ) ? $instance['botton_text_color'] : $defaults['botton_text_color'];
		$botton_background_color = ( isset( $instance['botton_background_color'] ) && '' !== $instance['botton_background_color'] ) ? $instance['botton_background_color'] : $defaults['botton_background_color'];
		$botton_background_hover_color = ( isset( $instance['botton_background_hover_color'] ) && '' !== $instance['botton_background_hover_color'] ) ? $instance['botton_background_hover_color'] : $defaults['botton_background_hover_color'];
		$link_url = ( isset( $instance[ 'link_url' ] ) && '' !== $instance[ 'link_url' ] ) ? $instance[ 'link_url' ] : $defaults['link_url'];
		$flip_text_link = ( isset( $instance[ 'flip_text_link' ] ) && '' !== $instance[ 'flip_text_link' ] ) ? $instance[ 'flip_text_link' ] : $defaults['flip_text_link'];
		$flip_botton_text = ( isset( $instance['flip_botton_text'] ) && '' !== $instance['flip_botton_text'] ) ? $instance['flip_botton_text'] : $defaults['flip_botton_text'];
		$flip_link_url = ( isset( $instance[ 'flip_link_url' ] ) && '' !== $instance[ 'flip_link_url' ] ) ? $instance[ 'flip_link_url' ] : $defaults['flip_link_url'];
		$flip_new_window = ( isset( $instance[ 'flip_new_window' ] ) && '' !== $instance[ 'flip_new_window' ] ) ? $instance[ 'flip_new_window' ] : $defaults['flip_new_window'];
		?>
     
        <p><label><input class="widefat" style="max-width:145px;" id="<?php echo esc_attr($this->get_field_id( 'botton_margin' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'botton_margin' )); ?>" type="text" value="<?php echo esc_attr($botton_margin); ?>"> <?php esc_html_e( 'Botton Margin', 'manual-framework' ); ?> <br>(top, right, buttom, left)</label></p>
        
        <p><label><input class="widefat" style="max-width:145px;" id="<?php echo esc_attr($this->get_field_id( 'botton_padding' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'botton_padding' )); ?>" type="text" value="<?php echo esc_attr($botton_padding); ?>"> <?php esc_html_e( 'Botton Padding', 'manual-framework' ); ?> <br>(top, right, buttom, left)</label></p>
        
        <hr />
        
        <p><label><input class="widefat" style="max-width:65px;" id="<?php echo esc_attr($this->get_field_id( 'font_size' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'font_size' )); ?>" type="text" value="<?php echo intval( $font_size ); ?>"><span class="pixels" style="display: inline-block;background:#efefef;position:relative;margin-left: -33px;padding: 3px 7px;">px</span> &nbsp;&nbsp;<?php esc_html_e( 'Botton Size', 'manual-framework' ); ?></label></p>
                
        <hr />
        
        <p><label for="<?php echo esc_attr($this->get_field_id( 'botton_text_color' )); ?>"><?php esc_html_e( 'Text Color:', 'manual-framework' ); ?></label> <input class="color-picker" type="text" id="<?php echo esc_attr($this->get_field_id( 'botton_text_color' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'botton_text_color' )); ?>" value="<?php echo esc_attr( $botton_text_color ); ?>" /></p>
        
        <p><label for="<?php echo esc_attr($this->get_field_id( 'botton_background_color' )); ?>"><?php esc_html_e( 'Botton Background Color:', 'manual-framework' ); ?></label> <input class="color-picker" type="text" id="<?php echo esc_attr($this->get_field_id( 'botton_background_color' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'botton_background_color' )); ?>" value="<?php echo esc_attr( $botton_background_color ); ?>" /></p>
        
        <p><label for="<?php echo esc_attr($this->get_field_id( 'botton_background_hover_color' )); ?>"><?php esc_html_e( 'Botton Background Hover Color:', 'manual-framework' ); ?></label> <input class="color-picker" type="text" id="<?php echo esc_attr($this->get_field_id( 'botton_background_hover_color' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'botton_background_hover_color' )); ?>" value="<?php echo esc_attr( $botton_background_hover_color ); ?>" /></p>
        
        <hr />
        
        <p><label> <input class="widefat" style="max-width:145px;" id="<?php echo esc_attr($this->get_field_id( 'botton_text' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'botton_text' )); ?>" type="text" value="<?php echo esc_html__($botton_text); ?>"> <?php esc_html_e( 'Botton Text', 'manual-framework' ); ?> </label></p>
        
        <p><label> <input class="widefat" style="max-width:145px;" id="<?php echo esc_attr($this->get_field_id( 'link_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_url' )); ?>" type="text" value="<?php echo esc_html__($link_url); ?>"> <?php esc_html_e( 'Link URL', 'manual-framework' ); ?> </label></p>

        <p><label> <input id="<?php echo esc_attr($this->get_field_id( 'new_window' )); ?>" type="checkbox" name="<?php echo esc_attr($this->get_field_name( 'new_window' )); ?>" value="1" <?php checked( 1, $new_window ); ?>/><?php esc_html_e( 'Open botton links in new window?', 'manual-framework' ); ?></label></p>
		
        <hr /><br>
        <p><label> <input id="<?php echo esc_attr($this->get_field_id( 'flip_text_link' )); ?>" type="checkbox" name="<?php echo esc_attr($this->get_field_name( 'flip_text_link' )); ?>" value="1" <?php checked( 1, $flip_text_link ); ?>/><span style="color:red;"><?php esc_html_e( 'Flip above text/link for the logged-in user', 'manual-framework' ); ?></span></label></p>
        
         <p><label> <input class="widefat" style="max-width:145px;" id="<?php echo esc_attr($this->get_field_id( 'flip_botton_text' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'flip_botton_text' )); ?>" type="text" value="<?php echo esc_html__($flip_botton_text); ?>"> <?php esc_html_e( 'Botton Text', 'manual-framework' ); ?> </label></p>
         
        <p><label> <input class="widefat" style="max-width:145px;" id="<?php echo esc_attr($this->get_field_id( 'flip_link_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'flip_link_url' )); ?>" type="text" value="<?php echo esc_html__($flip_link_url); ?>"> <?php esc_html_e( 'Link URL', 'manual-framework' ); ?> </label></p>
        
        <p><label> <input id="<?php echo esc_attr($this->get_field_id( 'flip_new_window' )); ?>" type="checkbox" name="<?php echo esc_attr($this->get_field_name( 'flip_new_window' )); ?>" value="1" <?php checked( 1, $flip_new_window ); ?>/><?php esc_html_e( 'Open botton links in new window?', 'manual-framework' ); ?></label></p>
        
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['botton_margin'] = $new_instance['botton_margin'];
		$instance['botton_padding'] = $new_instance['botton_padding'];
		$instance['font_size'] = intval( $new_instance['font_size'] );
		$instance['botton_text'] = $new_instance['botton_text'];
		$instance['link_url'] = $new_instance['link_url'];
		$instance['botton_text_color'] = $new_instance['botton_text_color'];
		$instance['botton_background_color'] = $new_instance['botton_background_color'];
		$instance['botton_background_hover_color'] = $new_instance['botton_background_hover_color'];
		$instance['new_window'] = ( isset( $instance['new_window'] ) ) ? strip_tags( $new_instance['new_window'] ) : '';
		$instance['flip_text_link'] = ( isset( $instance['flip_text_link'] ) ) ? strip_tags( $new_instance['flip_text_link'] ) : '';
		$instance['flip_botton_text'] = $new_instance['flip_botton_text'];
		$instance['flip_link_url'] = $new_instance['flip_link_url'];
		$instance['flip_new_window'] = ( isset( $instance['flip_new_window'] ) ) ? strip_tags( $new_instance['flip_new_window'] ) : '';
		return $instance;
	}

} // end of class

function manual__button_header_widget() { 
	register_widget( 'manual__button_header_widget_call' ); 
}
add_action( 'widgets_init', 'manual__button_header_widget' );


/**************************
*** CALL DEFAULT VALUE ***
***************************/
function manual__widget_botton_defaults() {
	
	$defaults = array(
		'new_window' => '',
		'botton_padding' => '10px 22px 10px 22px',
		'botton_margin' => '0px 0px 0px 0px',
		'font_size' => 14,
		'botton_text' => 'Login',
		'botton_text_color' => '',
		'botton_background_color' => '',
		'botton_background_hover_color' => '',
		'link_url' => '',
		'flip_text_link' => '',
		'flip_botton_text' => '',
		'flip_link_url' => '',
		'flip_new_window' => '',
	);
	return apply_filters( 'manual__widget_botton_defaults', $defaults );
}
?>