<?php

/**
 * Replies Loop - Single Reply
 *
 * @package bbPress
 * @subpackage Theme
 */

?>

<div id="post-<?php bbp_reply_id(); ?>" class="bbp-reply-header">
	<div <?php bbp_reply_class( $reply_id = 0, $classes = array('clearfix') ); ?>>
    
		<div class="bbp-reply-author clearfix">
			<?php do_action( 'bbp_theme_before_reply_author_details' ); ?>
			<?php bbp_reply_author_link( array( 'sep' => '', 'show_role' => true, 'size'  => '60' ) ); ?>
			<?php do_action( 'bbp_theme_after_reply_author_details' ); ?>
		</div><!-- .bbp-reply-author -->

		<div class="bbp-reply-content clearfix">
			<div class="bbp-meta clearfix"> <?php bbp_reply_post_date( $reply_id = 0, $humanize = true, $gmt = false ); ?> 
            
            <?php if ( bbp_is_single_user_replies() ) : ?>
			<span class="bbp-header">
				<?php esc_html_e( 'in reply to: ', 'manual' ); ?>
				<a class="bbp-topic-permalink" href="<?php bbp_topic_permalink( bbp_get_reply_topic_id() ); ?>"><?php bbp_topic_title( bbp_get_reply_topic_id() ); ?></a>
			</span>
		<?php endif; ?>
            
            <?php do_action( 'bbp_theme_before_reply_admin_links' ); ?>
			<?php bbp_reply_admin_links(); ?>
			<?php do_action( 'bbp_theme_after_reply_admin_links' ); ?>
            
            <a href="<?php bbp_reply_url(); ?>" class="bbp-reply-permalink">#<?php bbp_reply_id(); ?></a></div>
            <div class="reply-content-wrap">
				<?php do_action( 'bbp_theme_before_reply_content' ); ?>
                <?php bbp_reply_content(); ?>
                <?php do_action( 'bbp_theme_after_reply_content' ); ?>
            </div>
            <div class="bbp-arrow"></div>
		</div><!-- .bbp-reply-content -->
            
	</div><!-- .reply -->
</div><!-- #post-<?php bbp_reply_id(); ?> -->