<?php
namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class manual__mega_post_grid extends Widget_Base { 

	public function get_script_depends() {
		 return [ 'manual-ejs' ];
	}

	public function get_name() {  
		return 'manual-mega-post-grid';
	}

	public function get_title() {
		return esc_html__( 'Mega Post Grid', 'manual' );
	}

	public function get_icon() {
		return 'manual-elementor-icon mega-post-grid';
	}

	public function get_categories() {
		return [ 'manual-elements' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}
	
	// -- Post
	function manual__get_all_post_categories() {
		$postcategories_array = array();
		$post_categories = get_categories();
		foreach( $post_categories as $category ) {
			$postcategories_array[$category->term_id] = $category->name;
		}
		return $postcategories_array;
    }
	function manual__get_all_post_tags() {
		$postcategories_tags_array = array();
		$post_categories_tag = get_tags();
		foreach( $post_categories_tag as $tag ) {
			$postcategories_tags_array[$tag->term_id] = $tag->name;
		}
		return $postcategories_tags_array;
    }
	// -- Documentation
	function manual__get_all_doc_categories() {
		$doccategories_array = array();
		$categories = get_categories(array('taxonomy' => 'manualdocumentationcategory','parent' => 0,));
		foreach( $categories as $category ) {
			$doccategories_array[$category->term_id] = $category->name;
		}
		return $doccategories_array;
    }
	function manual__get_all_doc_post_tags() {
		$docpost_tags_array = array();
		$docpost_tags_array[] = '';
		$tags = get_terms(array('taxonomy' => 'manual_doc_tag','parent' => 0,'hide_empty' => false,));
		foreach( $tags as $tags ) {
			$docpost_tags_array[$tags->term_id] = $tags->name;
		}
		return $docpost_tags_array;
    }
	// -- Knowledgebase
	function manual__get_all_kb_categories() {
		$kbcategories_array = array();
		$kbcategories_array[] = '';
		$categories = get_categories(array('taxonomy' => 'manualknowledgebasecat','parent' => 0,));
		foreach( $categories as $category ) {
			$kbcategories_array[$category->term_id] = $category->name;
		}
		return $kbcategories_array;
    }
	function manual__get_all_kb_post_tags() {
		$kbpost_tags_array = array();
		$kbpost_tags_array[] = '';
		$tags = get_terms(array('taxonomy' => 'manual_kb_tag','parent' => 0,'hide_empty' => false,));
		foreach( $tags as $tags ) {
			$kbpost_tags_array[$tags->term_id] = $tags->name;
		}
		return $kbpost_tags_array;
    }
	// FAQ
	function manual__get_all_faq_categories() {
		$faq_array = array();
		$faq_array[] = '';
		$categories = get_categories(array('taxonomy' => 'manualfaqcategory','parent' => 0,));
		foreach( $categories as $category ) {
			$faq_array[$category->term_id] = $category->name;
		}
		return $faq_array;
    }

	protected function register_controls() {
		$this->start_controls_section(
			'section_tabs',
			[
				'label' => __( 'Settings', 'manual' )
			]
		);
		$this->add_control(
			'gridview_post_type',
			[
				'label'   => esc_html__( 'Post Type', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"post"	=> esc_html__( 'Post', 'manual' ),
					"manual_faq"	=> esc_html__( 'FAQs', 'manual' ),
					"manual_documentation"	=> esc_html__( 'Documentation', 'manual' ),
					"manual_kb"	=> esc_html__( 'Knowledge Base', 'manual' ),
				],
				'default' => 'post',
			]
		);
		$this->add_control(
			'include_post_category',
			[
				'label'   => esc_html__( 'Include Post From Category', 'manual' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->manual__get_all_post_categories(),
				'label_block' => true,
				'condition' => [ 'gridview_post_type' => 'post', ],
				'multiple' => true,
				'description'   => esc_html__('Leave empty to display all category', 'manual' ),
			]
		);
		$this->add_control(
			'include_post_category_tag',
			[
				'label'   => esc_html__( 'Show posts that are associated with specific tags', 'manual' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->manual__get_all_post_tags(),
				'label_block' => true,
				'condition' => [ 'gridview_post_type' => 'post', ],
				'multiple' => true,
				'description'   => esc_html__('To turn off this function, leave it blank', 'manual' ),
			]
		);
		// -- Knowledgebase
		$this->add_control(
			'include_kb_category',
			[
				'label'   => esc_html__( 'Include Post From Category', 'manual' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->manual__get_all_kb_categories(),
				'label_block' => true,
				'condition' => [ 'gridview_post_type' => 'manual_kb', ],
				'multiple' => true,
				'description'   => esc_html__('Leave empty to display all category', 'manual' ),
			]
		);
		$this->add_control(
			'include_kb_post_tags',
			[
				'label'   => esc_html__( 'Show posts that are associated with specific tags', 'manual' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->manual__get_all_kb_post_tags(),
				'label_block' => true,
				'condition' => [ 'gridview_post_type' => 'manual_kb', ],
				'multiple' => true,
				'description'   => esc_html__('To turn off this function, leave it blank', 'manual' ),
			]
		);
		// -- Documentation
		$this->add_control(
			'include_doc_category',
			[
				'label'   => esc_html__( 'Include Post From Category', 'manual' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->manual__get_all_doc_categories(),
				'label_block' => true,
				'condition' => [ 'gridview_post_type' => 'manual_documentation', ],
				'multiple' => true,
				'description'   => esc_html__('Leave empty to display all category', 'manual' ),
			]
		);
		$this->add_control(
			'include_doc_post_tags',
			[
				'label'   => esc_html__( 'Show posts that are associated with specific tags', 'manual' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->manual__get_all_doc_post_tags(),
				'label_block' => true,
				'condition' => [ 'gridview_post_type' => 'manual_documentation', ],
				'multiple' => true,
				'description'   => esc_html__('To turn off this function, leave it blank', 'manual' ),
			]
		);
		// -- FAQ
		$this->add_control(
			'include_faq_category',
			[
				'label'   => esc_html__( 'Include Post From Category', 'manual' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->manual__get_all_faq_categories(),
				'label_block' => true,
				'condition' => [ 'gridview_post_type' => 'manual_faq', ],
				'multiple' => true,
				'description'   => esc_html__('Leave empty to display all category', 'manual' ),
			]
		);
		$this->add_control(
			'design_presentation_type',
			[
				'label'   => esc_html__( 'Design Type', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"1"	=> esc_html__( 'Masonry', 'manual' ),
					"2"	=> esc_html__( 'FitRows', 'manual' ),
				],
				'default' => '2',
			]
		);
		$this->add_control(
			'type',
			[
				'label'   => esc_html__( 'Design Style', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"boxes"	=> esc_html__( 'Box', 'manual' ),
					"dividers"	=> esc_html__( 'Box Content With Dividers', 'manual' ),
				],
				'default' => 'boxes',
			]
		);
		$this->add_control(
			'box_height',
			[
				'label'       => __( 'Box Height', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'default' => '180',
				'min' => 50,
				'max' => 600,
				'step' => 10,
			]
		);
		$this->add_control(
			'number_of_posts',
			[
				'label'       => __( 'No. Of Posts', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'default' => '4',
				"description" =>  esc_html__('-1 == all post records', "manual"), 
				'min' => -1,
				'max' => 30,
				'step' => 1,
			]
		);
		$this->add_control(
			'number_of_colums',
			[
				'label'   => esc_html__( 'No. Of Colums', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"2"	=> esc_html__( 'Two', 'manual' ),
					"3"	=> esc_html__( 'Three', 'manual' ),
					"4"	=> esc_html__( 'Four', 'manual' ),
				],
				'default' => '3',
			]
		);
		$this->end_controls_section();
		
		
		/**********************
		*** SECTION - ORDER ***
		***********************/
		$this->start_controls_section(
			'section_tabs_order',
			[
				'label' => __( 'Order', 'manual' )
			]
		);
		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"ASC"  => esc_html__( 'Ascending', 'manual' ),
					"DESC"  => esc_html__( 'Descending', 'manual' ),
				],
				'default' => 'DESC',
				'label_block' => true,
			]
		);
		$this->add_control(
			'order_by',
			[
				'label'   => esc_html__( 'Order By', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"title"  => esc_html__( 'Title', 'manual' ),
					"date"  => esc_html__( 'Date', 'manual' ),
				],
				'default' => '',
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		
		
		/********************
		*** SECTION - TAG ***
		*********************/
		$this->start_controls_section(
			'section_tabs_tag',
			[
				'label' => __( 'Tag', 'manual' )
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__( 'Title HTML Tag', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"h3"  => esc_html__( 'H3', 'manual' ),
					"h4"  => esc_html__( 'H4', 'manual' ),
					"h5"  => esc_html__( 'H5', 'manual' ),
					"h6"  => esc_html__( 'H6', 'manual' ),
				],
				'default' => 'h4',
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		
		
		/**************************
		*** SECTION - SHOW/HIDE ***
		***************************/
		$this->start_controls_section(
			'section_tabs_show_hide',
			[
				'label' => __( 'Show/Hide', 'manual' )
			]
		);
		$this->add_control(
			'display_feature_image',
			[
				'label'   => esc_html__( 'Display Featured Image', 'manual' ),
				'type'    => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'feature_image_border_radius',
			[
				'label'       => __( 'Image Border Radius', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'default' => '5',
				'min' => 0,
				'max' => 30,
				'step' => 1,
				'condition' => [ 'display_feature_image' => 'yes', ],
			]
		);
		$this->add_control(
			'display_header_icon',
			[
				'label'   => esc_html__( 'Display header Icon', 'manual' ),
				'type'    => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'header_icon_name_default',
			[
				'label'       => __( 'Icon', 'manual' ),
				'type'        => Controls_Manager::ICONS,
				'default' => [
								'value' => '',
								'library' => 'solid',
							],
				'condition' => [ 'display_header_icon' => 'yes', ],
			]
		);
		$this->add_control(
			'icon_font_size',
			[
				'label'       => __( 'Icon Font Size', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'default' => '34',
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'condition' => [ 'display_header_icon' => 'yes', ],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'manual' ),
				'type'  => Controls_Manager::COLOR,
				'default' => '',
				'condition' => [ 'display_header_icon' => 'yes', ],
			]
		);
		$this->add_control(
			'icon_margin_botton',
			[
				'label'       => __( 'Icon Margin Botton', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'default' => '30',
				'min' => 0,
				'max' => 200,
				'step' => 1,
				'condition' => [ 'display_header_icon' => 'yes', ],
			]
		);
		
		$this->add_control(
			'display_excerpt_read',
			[
				'label'   => esc_html__( 'Display Content', 'manual' ),
				'type'    => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'content_limit',
			[
				'label'       => __( 'No. Of Characters', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'default' => '15',
				'min' => 0,
				'max' => 200,
				'step' => 1,
				'condition' => [ 'display_excerpt_read' => 'yes', ],
			]
		);
		$this->add_control(
			'display_continue_read',
			[
				'label'   => esc_html__( 'Display Continue Reading', 'manual' ),
				'type'    => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'continue_reading_txt',
			[
				'label'       => __( 'Continue Reading Text', 'manual' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Continue Reading', 'manual' ),
				'label_block' => true,
				'default' => 'Continue Reading',
				'condition' => [ 'display_continue_read' => 'yes', ],
			]
		);
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$instance = array(
			"gridview_post_type"       => $settings['gridview_post_type'],
            "include_post_category"    => $settings['include_post_category'],
            "include_post_category_tag"    => $settings['include_post_category_tag'],
            "include_kb_category"      => $settings['include_kb_category'],
            "include_kb_post_tags"      => $settings['include_kb_post_tags'],
            "include_doc_category"     => $settings['include_doc_category'],
            "include_doc_post_tags"     => $settings['include_doc_post_tags'],
			"include_faq_category"     => $settings['include_faq_category'],
			"design_presentation_type" => $settings['design_presentation_type'],
			"type"       			 => $settings['type'],
			"number_of_posts"        => $settings['number_of_posts'],
			"number_of_colums"       => $settings['number_of_colums'],
			"order_by"               => $settings['order_by'],
            "order"                  => $settings['order'],
			"title_tag"              => $settings['title_tag'],
			"display_feature_image"  => $settings['display_feature_image'],
			"display_excerpt_read"   => $settings['display_excerpt_read'],
			"content_limit"          => $settings['content_limit'],
			"display_continue_read"  => $settings['display_continue_read'],
			"continue_reading_txt"   => $settings['continue_reading_txt'],
			"display_header_icon"    => $settings['display_header_icon'],
			"header_icon_name_default"   => $settings['header_icon_name_default'],
			"icon_color"                 => $settings['icon_color'],
			"icon_margin_botton"         => $settings['icon_margin_botton'],
			"icon_font_size"             => $settings['icon_font_size'],
			"box_height"                 => $settings['box_height'],
			"feature_image_border_radius"  => $settings['feature_image_border_radius'],
		);
		manual__get_widget_template( $this->get_base(), array( 'instance' => $instance ) );
	}

}

Plugin::instance()->widgets_manager->register( new manual__mega_post_grid() );