<?php
namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class manual__wedocs extends Widget_Base { 
	
	public function get_script_depends() {
		 return [ 'manual-ejs' ];
	}
	
	public function get_name() {  
		return 'manual-wedocs';
	}

	public function get_title() {
		return esc_html__( 'weDocs', 'manual' );
	}

	public function get_icon() {
		return 'manual-elementor-icon wedocs';
	}

	public function get_categories() {
		return [ 'manual-elements' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}
	
	function manual__get_all_wedocs__rootcategories() {
		$wedocs_array = array();
		$wedocs_array[] = '';
		$root_articles = get_pages(array( 'post_type' => 'docs', 'parent' => 0 ));
		foreach( $root_articles as $post ) {
			$wedocs_array[$post->ID] = $post->post_title;
		}
		return $wedocs_array;
    }

	protected function register_controls() {
		$this->start_controls_section(
			'section_tabs',
			[
				'label' => __( 'weDocs', 'manual' )
			]
		);
		$this->add_control(
			'wedocs_style_type',
			[
				'label'   => esc_html__( 'Display Type', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"1"  => esc_html__( 'Masonry', 'manual' ),
					"2"  => esc_html__( 'FitRows', 'manual' ),
				],
				'default' => '2',
			]
		);
		$this->add_control(
			'wedocs_column',
			[
				'label'   => esc_html__( 'Columns', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"4"  => esc_html__( '3 Columns', 'manual' ),
					"6"  => esc_html__( '2 Columns', 'manual' ),
					"12"  => esc_html__( '1 Columns', 'manual' ),
				],
				'default' => '4',
				'label_block' => true,
			]
		);
		$this->add_control(
			'wedocs_no_of_articles',
			[
				'label'       => __( 'No. Of Articles Under Root Articles', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'default' => -1,
				'min' => -1,
				'max' => 50,
				'step' => 1,
			]
		);
		$this->add_control(
			'wedocs_exclude_rootid',
			[
				'label'   => esc_html__( 'Exclude Root Articles', 'manual' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->manual__get_all_wedocs__rootcategories(),
				'label_block' => true,
				'multiple' => true,
			]
		);
		$this->end_controls_section();
		/**********************
		*** SECTION - ORDER ***
		***********************/
		$this->start_controls_section(
			'section_tabs_order',
			[
				'label' => __( 'Order', 'manual' )
			]
		);
		$this->add_control(
			'wedocs_root_article_order',
			[
				'label'   => esc_html__( 'Root Records Order', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"ASC"  => esc_html__( 'Ascending', 'manual' ),
					"DESC"  => esc_html__( 'Descending', 'manual' ),
				],
				'default' => 'DESC',
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		/********************
		*** SECTION - TAG ***
		*********************/
		$this->start_controls_section(
			'section_tabs_tag',
			[
				'label' => __( 'Tag', 'manual' )
			]
		);
		$this->add_control(
			'wedocs_title_tag',
			[
				'label'   => esc_html__( 'Title Tag', 'manual' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"h3"  => esc_html__( 'H3', 'manual' ),
					"h4"  => esc_html__( 'H4', 'manual' ),
					"h5"  => esc_html__( 'H5', 'manual' ),
					"h6"  => esc_html__( 'H6', 'manual' ),
				],
				'default' => 'h5',
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		/**************************
		*** SECTION - SHOW/HIDE ***
		***************************/
		$this->start_controls_section(
			'section_tabs_show_hide',
			[
				'label' => __( 'Show/Hide', 'manual' )
			]
		);
		$this->add_control(
			'wedocs_root_icon',
			[
				'label'   => esc_html__( 'Show Icon (image/icon)', 'manual' ),
				'type'    => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'wedocs_desc',
			[
				'label'   => esc_html__( 'Show "Description"', 'manual' ),
				'type'    => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'wedocs_read_more_text_display',
			[
				'label'   => esc_html__( 'Show "View All" Text', 'manual' ),
				'type'    => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'wedocs_view_all',
			[
				'label'       => __( 'Text', 'manual' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'View All', 'manual' ),
				'label_block' => true,
				'default' => 'View All',
				'condition' => [ 'wedocs_read_more_text_display' => 'yes', ],
			]
		);
		$this->end_controls_section();
		/**************************
		*** SECTION - DESIGN ***
		***************************/
		$this->start_controls_section(
			'section_tabs_design',
			[
				'label' => __( 'Design', 'manual' )
			]
		);
		$this->add_control(
			'article_icon_color',
			[
				'label' => esc_html__( 'Article icon Color', 'manual' ),
				'type'  => Controls_Manager::COLOR,
				'default' => '#f3d973',
				'description'   => esc_html__('Icon before article title', 'manual' ),
			]
		);
		$this->add_control(
			'box_shadow',
			[
				'label'   => esc_html__( 'Apply Box Shadow', 'manual' ),
				'type'    => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'box_padding',
			[
				'label'       => __( 'Box Padding', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'default' => '35',
				"description" =>  esc_html__('Default:35', "manual"), 
				'min' => 15,
				'max' => 100,
				'step' => 1,
			]
		);
		$this->add_control(
			'box_border_color',
			[
				'label' => esc_html__( 'Box Border Color', 'manual' ),
				'type'  => Controls_Manager::COLOR,
				'default' => '#daf6fc',
			]
		);
		$this->add_control(
			'box_border_width',
			[
				'label'       => __( 'Box Border Width', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'default' => '1',
				'min' => 1,
				'max' => 10,
				'step' => 1,
			]
		);
		$this->add_control(
			'box_bg_color',
			[
				'label' => esc_html__( 'Box Background Color', 'manual' ),
				'type'  => Controls_Manager::COLOR,
				'default' => '#FFFFFF',
			]
		);
		$this->add_control(
			'root_article_icon_size',
			[
				'label'       => __( 'Root Article Icon Size (px)', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'min' => 8,
				'max' => 300,
				'step' => 1,
				'default' => 50,
			]
		);
		$this->add_control(
			'root_article_desc_limit',
			[
				'label'       => __( 'Limit Desc words', 'manual' ),
				'type'        => Controls_Manager::NUMBER,
				'min' => 8,
				'max' => 50,
				'step' => 1,
				'default' => 7,
				'condition' => [ 'wedocs_desc' => 'yes', ],
			]
		);
		$this->end_controls_section();
		
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$instance = array(
			"wedocs_style_type"    => $settings['wedocs_style_type'],
			"wedocs_column"        => $settings['wedocs_column'],
			"wedocs_no_of_articles"   => $settings['wedocs_no_of_articles'],
			"wedocs_root_article_order"   => $settings['wedocs_root_article_order'],
			"wedocs_title_tag"   => $settings['wedocs_title_tag'],
			"wedocs_root_icon"   => $settings['wedocs_root_icon'],
			"wedocs_desc"   => $settings['wedocs_desc'],
			"wedocs_read_more_text_display"   => $settings['wedocs_read_more_text_display'],
			"wedocs_view_all"   => $settings['wedocs_view_all'],
			"article_icon_color"   => $settings['article_icon_color'],
			"box_shadow"   => $settings['box_shadow'],
			"box_padding"   => $settings['box_padding'],
			"box_border_color"   => $settings['box_border_color'],
			"box_border_width"   => $settings['box_border_width'],
			"box_bg_color"   => $settings['box_bg_color'],
			"root_article_icon_size"   => $settings['root_article_icon_size'],
			"wedocs_exclude_rootid"   => $settings['wedocs_exclude_rootid'],
			"root_article_desc_limit"   => $settings['root_article_desc_limit'],
		);
		manual__get_widget_template( $this->get_base(), array( 'instance' => $instance ) );
	}

}
Plugin::instance()->widgets_manager->register( new manual__wedocs() );